/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing;

import edu.princeton.swing.ClipboardTarget;
import edu.princeton.swing.ClipboardTargetManager;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class PTextField
extends JTextField
implements ClipboardTarget {
    private static final Toolkit TOOLKIT = Toolkit.getDefaultToolkit();
    private JPopupMenu popupMenu;
    private Vector actionListeners;
    private String actionCommand;

    public PTextField() {
        this.initTextField();
    }

    public PTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.initTextField();
    }

    public PTextField(int columns) {
        super(columns);
        this.initTextField();
    }

    public PTextField(String text) {
        super(text);
        this.initTextField();
    }

    public PTextField(String text, int columns) {
        super(text, columns);
        this.initTextField();
    }

    private void initTextField() {
        this.popupMenu = ClipboardTargetManager.createDefaultPopupMenu();
        this.actionListeners = new Vector();
        this.actionCommand = null;
        ClipboardTargetManager.installMappings(this);
        this.enableEvents(28L);
    }

    @Override
    public synchronized void addActionListener(ActionListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.actionListeners.add(listener);
    }

    @Override
    public synchronized void removeActionListener(ActionListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.actionListeners.remove(listener);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    public void setActionCommand(String actionCommand) {
        if (!(this.actionCommand == actionCommand || actionCommand == null && actionCommand.equals(this.actionCommand))) {
            String oldValue = this.actionCommand;
            this.actionCommand = actionCommand;
            this.firePropertyChange("actionCommand", oldValue, actionCommand);
        }
    }

    @Override
    public boolean canCut() {
        return this.isEnabled() && this.isEditable();
    }

    @Override
    public boolean canCopy() {
        return this.isEnabled();
    }

    @Override
    public boolean canPaste() {
        return this.isEnabled() && this.isEditable();
    }

    @Override
    public boolean canSelectAll() {
        return this.isEnabled();
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            if (e.getID() == 401 && !this.actionListeners.isEmpty()) {
                String actionCommand = this.actionCommand;
                if (actionCommand == null) {
                    actionCommand = this.getText();
                }
                ActionEvent actionEvent = new ActionEvent(this, 1001, actionCommand);
                Object[] array = this.actionListeners.toArray();
                for (int ctr = 0; ctr < array.length; ++ctr) {
                    ((ActionListener)array[ctr]).actionPerformed(actionEvent);
                }
            }
            e.consume();
        }
        super.processKeyEvent(e);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            ClipboardTargetManager.targetGainedFocus(this);
        } else if (e.getID() == 1005) {
            ClipboardTargetManager.targetLostFocus(this);
        }
        super.processFocusEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        boolean passedToSuper = false;
        if (this.popupMenu != null && e.isPopupTrigger()) {
            if (!this.hasFocus()) {
                this.requestFocus();
            }
            int x = e.getX();
            int y = e.getY();
            Point componentLocation = this.getLocationOnScreen();
            Dimension screenSize = TOOLKIT.getScreenSize();
            Dimension preferredSize = this.popupMenu.getPreferredSize();
            if (componentLocation.x + x + preferredSize.width > screenSize.width) {
                x -= preferredSize.width;
            }
            if (componentLocation.y + y + preferredSize.height > screenSize.height) {
                y -= preferredSize.height;
            }
            e.consume();
            passedToSuper = true;
            super.processMouseEvent(e);
            this.popupMenu.show(this, x, y);
        }
        if (!passedToSuper) {
            super.processMouseEvent(e);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ClipboardTargetManager.targetAbilityChanged(this);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        ClipboardTargetManager.targetAbilityChanged(this);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        if (popupMenu != this.popupMenu) {
            if (popupMenu != null && this.popupMenu.isVisible()) {
                this.popupMenu.setVisible(false);
            }
            JPopupMenu oldValue = this.popupMenu;
            this.popupMenu = popupMenu;
            this.firePropertyChange("popupMenu", oldValue, popupMenu);
        }
    }
}

